<?php

namespace App\ERP;

use Illuminate\Database\Eloquent\Model;

class Articulo extends Model 
{

    protected $table = 'articulos';
    public $timestamps = true;

    public function familia()
    {
        return $this->belongsTo('FamiliaProductos', 'familia_id');
    }

    public function IVA()
    {
        return $this->belongsTo('TipoIva', 'tipo_iva_id');
    }

    public function fabricante()
    {
        return $this->belongsTo('Fabricante', 'fabricante_id');
    }

    public function almacenPreferido()
    {
        return $this->belongsTo('Almacen', 'almacen_preferido_id');
    }

    public function facurasRelacionadas()
    {
        return $this->hasMany('ArticuloFacturas', 'articulo_id');
    }

    public function articulosReales()
    {
        return $this->hasMany('ArticuloReal', 'articulo_id');
    }

    public function proveedorPreferido()
    {
        return $this->belongsTo('Proveedor', 'proveedor_preferido_id');
    }

    public function tarifas()
    {
        return $this->hasMany('App\ERP\TarifaArticulo', 'articulo_id');
    }

}